<?php
class AfricasTalkingSMS {
    private $username;
    private $apiKey;
    private $from;
    
    public function __construct($config) {
        $this->username = $config['username'];
        $this->apiKey = $config['api_key'];
        $this->from = $config['from'] ?? 'TeacherSchemes';
    }
    
    public function sendSMS($phoneNumber, $message) {
        $url = 'https://api.africastalking.com/version1/messaging';
        
        $data = [
            'username' => $this->username,
            'to' => $phoneNumber,
            'message' => $message,
            'from' => $this->from
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'apiKey: ' . $this->apiKey,
            'Content-Type: application/x-www-form-urlencoded',
            'Accept: application/json'
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 201) {
            throw new Exception('SMS sending failed');
        }
        
        return json_decode($response, true);
    }
    
    public function sendBulkSMS($phoneNumbers, $message) {
        $results = [];
        
        foreach ($phoneNumbers as $phoneNumber) {
            try {
                $result = $this->sendSMS($phoneNumber, $message);
                $results[] = [
                    'phone_number' => $phoneNumber,
                    'success' => true,
                    'result' => $result
                ];
            } catch (Exception $e) {
                $results[] = [
                    'phone_number' => $phoneNumber,
                    'success' => false,
                    'error' => $e->getMessage()
                ];
            }
        }
        
        return $results;
    }
}
?>