<?php
// src/Domain/ValueObjects/TransactionId.php
class TransactionId {
    private $value;
    
    public function __construct($value = null) {
        $this->value = $value ?: 'TXN-' . uniqid();
    }
    
    public function getValue() {
        return $this->value;
    }
    
    public function equals(TransactionId $other) {
        return $this->value === $other->value;
    }
    
    public function __toString() {
        return $this->value;
    }
}