<?php
// src/Domain/ValueObjects/PhoneNumber.php
class PhoneNumber {
    private $number;
    
    public function __construct($number) {
        if (!$this->isValid($number)) {
            throw new InvalidArgumentException('Invalid phone number format');
        }
        $this->number = $number;
    }
    
    private function isValid($number) {
        return preg_match('/^254[0-9]{9}$/', $number);
    }
    
    public function getValue() {
        return $this->number;
    }
    
    public function getFormattedNumber() {
        return $this->number;
    }
    
    public function __toString() {
        return $this->number;
    }
}