<?php
// src/Domain/ValueObjects/Money.php
class Money {
    private $amount;
    private $currency;
    
    public function __construct($amount, $currency = 'KSH') {
        if ($amount < 0) {
            throw new InvalidArgumentException('Amount cannot be negative');
        }
        $this->amount = (float) $amount;
        $this->currency = $currency;
    }
    
    public function getAmount() {
        return $this->amount;
    }
    
    public function getCurrency() {
        return $this->currency;
    }
    
    public function add(Money $other) {
        if ($this->currency !== $other->currency) {
            throw new InvalidArgumentException('Cannot add different currencies');
        }
        return new Money($this->amount + $other->amount, $this->currency);
    }
    
    public function equals(Money $other) {
        return $this->amount === $other->amount && $this->currency === $other->currency;
    }
    
    public function __toString() {
        return $this->currency . ' ' . number_format($this->amount, 2);
    }
}
