<?php
// src/Domain/Services/PricingService.php
class PricingService {
    public static function calculateTotal($itemCount) {
        if ($itemCount <= 0) return new Money(0);
        if ($itemCount == 1) return new Money(30);
        if ($itemCount == 2) return new Money(40);
        
        // For 3+ items, use the most economical combination
        $groupsOfThree = intval($itemCount / 3);
        $remainder = $itemCount % 3;
        
        $total = $groupsOfThree * 50;
        
        if ($remainder == 1) $total += 30;
        if ($remainder == 2) $total += 40;
        
        return new Money($total);
    }
    
    public static function getBreakdown($itemCount) {
        if ($itemCount <= 0) return [];
        if ($itemCount == 1) return [['description' => '1 scheme', 'amount' => 30]];
        if ($itemCount == 2) return [['description' => '2 schemes', 'amount' => 40]];
        
        $breakdown = [];
        $groupsOfThree = intval($itemCount / 3);
        $remainder = $itemCount % 3;
        
        if ($groupsOfThree > 0) {
            $breakdown[] = [
                'description' => $groupsOfThree . ' group(s) of 3',
                'amount' => $groupsOfThree * 50
            ];
        }
        
        if ($remainder == 1) {
            $breakdown[] = ['description' => '1 additional', 'amount' => 30];
        } elseif ($remainder == 2) {
            $breakdown[] = ['description' => '2 additional', 'amount' => 40];
        }
        
        return $breakdown;
    }
}
