<?php
// src/Domain/Entities/Transaction.php
class Transaction {
    private $id;
    private $transactionId;
    private $orderId;
    private $amount;
    private $phoneNumber;
    private $mpesaReceiptNumber;
    private $checkoutRequestId;
    private $status;
    private $createdAt;
    private $updatedAt;
    
    const STATUS_PENDING = 'pending';
    const STATUS_COMPLETED = 'completed';
    const STATUS_FAILED = 'failed';
    const STATUS_CANCELLED = 'cancelled';
    
    public function __construct($transactionId, $orderId, $amount, $phoneNumber) {
        $this->transactionId = $transactionId;
        $this->orderId = $orderId;
        $this->amount = $amount;
        $this->phoneNumber = $phoneNumber;
        $this->status = self::STATUS_PENDING;
        $this->createdAt = new DateTime();
        $this->updatedAt = new DateTime();
    }
    
    // Getters
    public function getId() { return $this->id; }
    public function getTransactionId() { return $this->transactionId; }
    public function getOrderId() { return $this->orderId; }
    public function getAmount() { return $this->amount; }
    public function getPhoneNumber() { return $this->phoneNumber; }
    public function getMpesaReceiptNumber() { return $this->mpesaReceiptNumber; }
    public function getCheckoutRequestId() { return $this->checkoutRequestId; }
    public function getStatus() { return $this->status; }
    public function getCreatedAt() { return $this->createdAt; }
    public function getUpdatedAt() { return $this->updatedAt; }
    
    // Setters
    public function setId($id) { $this->id = $id; }
    public function setMpesaReceiptNumber($receiptNumber) { 
        $this->mpesaReceiptNumber = $receiptNumber; 
        $this->updatedAt = new DateTime();
    }
    public function setCheckoutRequestId($checkoutRequestId) { 
        $this->checkoutRequestId = $checkoutRequestId; 
        $this->updatedAt = new DateTime();
    }
    
    // Business Logic
    public function markAsCompleted($mpesaReceiptNumber) {
        $this->status = self::STATUS_COMPLETED;
        $this->mpesaReceiptNumber = $mpesaReceiptNumber;
        $this->updatedAt = new DateTime();
    }
    
    public function markAsFailed() {
        $this->status = self::STATUS_FAILED;
        $this->updatedAt = new DateTime();
    }
    
    public function markAsCancelled() {
        $this->status = self::STATUS_CANCELLED;
        $this->updatedAt = new DateTime();
    }
}
