<?php
// src/Domain/Entities/Order.php
class Order {
    private $id;
    private $orderNumber;
    private $customerId;
    private $totalItems;
    private $totalAmount;
    private $status;
    private $createdAt;
    private $items = [];
    
    const STATUS_PENDING = 'pending';
    const STATUS_PAID = 'paid';
    const STATUS_COMPLETED = 'completed';
    const STATUS_FAILED = 'failed';
    
    public function __construct($orderNumber, $customerId, $totalItems, $totalAmount) {
        $this->orderNumber = $orderNumber;
        $this->customerId = $customerId;
        $this->totalItems = $totalItems;
        $this->totalAmount = $totalAmount;
        $this->status = self::STATUS_PENDING;
        $this->createdAt = new DateTime();
    }
    
    // Getters
    public function getId() { return $this->id; }
    public function getOrderNumber() { return $this->orderNumber; }
    public function getCustomerId() { return $this->customerId; }
    public function getTotalItems() { return $this->totalItems; }
    public function getTotalAmount() { return $this->totalAmount; }
    public function getStatus() { return $this->status; }
    public function getCreatedAt() { return $this->createdAt; }
    public function getItems() { return $this->items; }
    
    // Setters
    public function setId($id) { $this->id = $id; }
    public function setStatus($status) { $this->status = $status; }
    public function addItem(OrderItem $item) { $this->items[] = $item; }
    
    // Business Logic
    public function markAsPaid() {
        $this->status = self::STATUS_PAID;
    }
    
    public function markAsCompleted() {
        $this->status = self::STATUS_COMPLETED;
    }
    
    public function markAsFailed() {
        $this->status = self::STATUS_FAILED;
    }
}
