<?php
class SchemeController {
    private $schemeRepository;
    
    public function __construct() {
        $this->schemeRepository = new MySQLSchemeRepository();
    }
    
    public function getAllSchemes() {
        try {
            $filters = [
                'subject' => $_GET['subject'] ?? '',
                'grade_level' => $_GET['grade_level'] ?? '',
                'term' => $_GET['term'] ?? '',
                'year' => $_GET['year'] ?? ''
            ];
            
            // Remove empty filters
            $filters = array_filter($filters);
            
            $schemes = $this->schemeRepository->findAll($filters);
            
            // Convert to array for JSON output
            $schemesArray = [];
            foreach ($schemes as $scheme) {
                $schemesArray[] = [
                    'id' => $scheme->getId(),
                    'title' => $scheme->getTitle(),
                    'description' => $scheme->getDescription(),
                    'subject' => $scheme->getSubject(),
                    'grade_level' => $scheme->getGradeLevel(),
                    'term' => $scheme->getTerm(),
                    'year' => $scheme->getYear(),
                    'file_type' => $scheme->getFileType(),
                    'file_size' => $scheme->getFileSize()
                ];
            }
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'schemes' => $schemesArray
            ]);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }
    
    public function getSchemeById($id) {
        try {
            $scheme = $this->schemeRepository->findById($id);
            
            if (!$scheme) {
                http_response_code(404);
                echo json_encode([
                    'success' => false,
                    'message' => 'Scheme not found'
                ]);
                return;
            }
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'scheme' => [
                    'id' => $scheme->getId(),
                    'title' => $scheme->getTitle(),
                    'description' => $scheme->getDescription(),
                    'subject' => $scheme->getSubject(),
                    'grade_level' => $scheme->getGradeLevel(),
                    'term' => $scheme->getTerm(),
                    'year' => $scheme->getYear(),
                    'file_type' => $scheme->getFileType(),
                    'file_size' => $scheme->getFileSize()
                ]
            ]);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }
}
?>