<?php
class PaymentController {
    private $paymentApplicationService;
    private $transactionRepository;
    
    public function __construct() {
        $this->paymentApplicationService = new PaymentApplicationService();
        $this->transactionRepository = new MySQLTransactionRepository();
    }
    
    public function initiate() {
        try {
            $phoneNumber = $_POST['phone_number'] ?? '';
            $cartData = json_decode($_POST['cart_data'] ?? '[]', true);
            $totalAmount = intval($_POST['total_amount'] ?? 0);
            $customerName = $_POST['customer_name'] ?? '';
            
            // Validate input
            if (!$phoneNumber || empty($cartData) || $totalAmount <= 0) {
                throw new Exception('Invalid request data');
            }
            
            // Validate phone number
            $phoneNumberVO = new PhoneNumber($phoneNumber);
            
            // Validate pricing
            $calculatedTotal = PricingService::calculateTotal(count($cartData));
            if ($totalAmount !== $calculatedTotal->getAmount()) {
                throw new Exception('Price mismatch');
            }
            
            // Process payment
            $result = $this->paymentApplicationService->initiatePayment($phoneNumber, $cartData, $customerName);
            
            header('Content-Type: application/json');
            echo json_encode($result);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => $e->getMessage()
            ]);
        }
    }
    
    public function callback() {
        try {
            $input = file_get_contents('php://input');
            $callbackData = json_decode($input, true);
            
            // Log callback for debugging
            error_log('M-Pesa Callback: ' . $input);
            
            $result = $this->paymentApplicationService->handleCallback($callbackData);
            
            // Respond to M-Pesa
            header('Content-Type: application/json');
            echo json_encode(['ResultCode' => 0, 'ResultDesc' => 'Success']);
            
        } catch (Exception $e) {
            error_log('M-Pesa callback error: ' . $e->getMessage());
            
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode(['ResultCode' => 1, 'ResultDesc' => 'Failed']);
        }
    }
    
    public function status($transactionId) {
        try {
            $transaction = $this->transactionRepository->findByTransactionId($transactionId);
            
            if (!$transaction) {
                throw new Exception('Transaction not found');
            }
            
            header('Content-Type: application/json');
            echo json_encode([
                'status' => $transaction->getStatus(),
                'order_id' => $transaction->getOrderId(),
                'amount' => $transaction->getAmount()
            ]);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
            http_response_code(404);
            echo json_encode([
                'error' => $e->getMessage()
            ]);
        }
    }
}
?>