<?php
class HistoryController {
    private $orderRepository;
    private $customerRepository;
    
    public function __construct() {
        $this->orderRepository = new MySQLOrderRepository();
        $this->customerRepository = new MySQLCustomerRepository();
    }
    
    public function getCustomerHistory() {
        try {
            $phoneNumber = $_GET['phone_number'] ?? '';
            
            if (!$phoneNumber) {
                throw new Exception('Phone number is required');
            }
            
            // Validate phone number
            $phoneNumberVO = new PhoneNumber($phoneNumber);
            
            // Find customer
            $customer = $this->customerRepository->findByPhoneNumber($phoneNumber);
            if (!$customer) {
                header('Content-Type: application/json');
                echo json_encode([
                    'success' => true,
                    'orders' => []
                ]);
                return;
            }
            
            // Get customer orders
            $orders = $this->orderRepository->findByCustomerId($customer->getId());
            
            // Convert to array for JSON
            $ordersArray = [];
            foreach ($orders as $order) {
                if ($order->getStatus() === 'completed') {
                    $orderItems = $this->getOrderItems($order->getId());
                    
                    $ordersArray[] = [
                        'id' => $order->getId(),
                        'order_number' => $order->getOrderNumber(),
                        'total_items' => $order->getTotalItems(),
                        'total_amount' => $order->getTotalAmount(),
                        'status' => $order->getStatus(),
                        'created_at' => $order->getCreatedAt()->format('Y-m-d H:i:s'),
                        'items' => $orderItems
                    ];
                }
            }
            
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'orders' => $ordersArray
            ]);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
        }
    }
    }